#version 330 core
layout (location = 0) in vec4 vertex; // <vec2 pos, vec2 tex>
out vec2 TexCoords;

uniform mat4 projection;
uniform mat4 view;
uniform mat4 cameraProjection;

uniform vec3 textWorldPos;
uniform vec2 textPixelOffset;

uniform int screenWidth;
uniform int screenHeight;


void main()
{
	vec4 worldPos = cameraProjection * view * vec4(textWorldPos.xyz, 1.0);

	vec2 screenSpaceMultiplier = vec2(1.0 / float(screenWidth), 1.0 / float(screenHeight));

	vec4 billboardPos = vec4((vertex.xy + textPixelOffset) * screenSpaceMultiplier, 0.0, 0.0);


	gl_Position = worldPos;

	gl_Position /= gl_Position.w;

	gl_Position.xy += billboardPos.xy;

  TexCoords = vertex.zw;
} 